<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Homepage</title>
        <style>
            body {
                font-family: 'Roboto', sans-serif;
                margin: 0;
                padding: 0;
                background-color: #f4f4f4;
                color: #333;
                background-image: url('<?php echo base_url('assets/images/background.jpg'); ?>');
                background-size: cover;
                background-position: center;
            }

            header {
                background: linear-gradient(135deg, #2c6975, #68b0ab);
                color: #fff;
                padding: 20px;
                text-align: center;
                position: relative;
                box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            }

            .logo {
                position: absolute;
                left: 20px;
                top: 20px;
                height: 50px;
                border-radius: 50%;
                object-fit: cover; /* Ensures the image covers the entire area */
            }

            nav ul {
                list-style: none;
                padding: 0;
                margin: 0;
                display: flex;
                justify-content: center;
            }

            nav ul li {
                margin: 0 15px;
            }

            nav ul li a {
                color: #fff;
                text-decoration: none;
                font-weight: 500;
                transition: color 0.3s ease;
                cursor: pointer;
            }

            nav ul li a:hover {
                color: #ddd;
            }

            main {
                padding: 60px 20px;
                max-width: 1200px;
                margin: 0 auto;
                background-color: rgba(255, 255, 255, 0.5);
                box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
                border-radius: 12px;
            }

            section {
                margin-bottom: 40px;
            }

            h2 {
                color: #045c51;
                font-size: 27px;
                margin-bottom: 15px;
                border-bottom: 3px solid #68b0ab;
                padding-bottom: 10px;

                letter-spacing: 2px;
            }

            footer {
                background: linear-gradient(135deg, #2c6975, #68b0ab);
                color: #fff;
                text-align: center;
                padding: 20px;
                box-shadow: 0 -4px 6px rgba(0, 0, 0, 0.1);
            }


            #about p {

                font-size: 19px;
                line-height: 1.6;
                font-weight: 400;
                color: #333;
                text-align: center;
                margin-bottom: 20px;
            }


            .contact-wrapper {
                display: flex;
                flex-direction: column;
                gap: 20px;
            }

            .map, .contact-form {
                flex: 1;
                max-width: 100%;
                margin: 0;
            }

            .contact-form {
                background: #fff;
                padding: 30px;
                border-radius: 8px;
                box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            }

            .contact-form input, .contact-form textarea {
                width: 100%;
                padding: 12px;
                margin: 10px 0;
                border: 1px solid #ddd;
                border-radius: 6px;
                box-sizing: border-box;
            }

            .contact-form button {
                background: #2c6975;
                color: #fff;
                border: none;
                padding: 12px;
                border-radius: 6px;
                cursor: pointer;
                font-size: 16px;
                transition: background 0.3s ease;
            }

            .contact-form button:hover {
                background: #2b4b6f;
            }

            .card-container {
                display: flex;
                gap: 20px;
                flex-wrap: wrap;
                justify-content: center;
            }

            .card {
                background-color: #045c51;
                color: #fff;
                border-radius: 12px;
                padding: 30px;
                width: 300px;
                box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
                text-align: center;
                transition: transform 0.3s ease, box-shadow 0.3s ease;
            }

            .card h3 {
                margin-bottom: 15px;
                color: #045c51;
                font-size: 22px;
                text-shadow: 1px 1px 0 #fff, -1px -1px 0 #fff, 1px -1px 0 #fff, -1px 1px 0 #fff;
            }

            .card p {
                font-size: 16px;
                line-height: 1.6;
            }

            .card:hover {
                transform: translateY(-10px); /* Lift effect on hover */
                box-shadow: 0 12px 20px rgba(0, 0, 0, 0.2);
            }

            .personnel-container {
                display: flex;
                flex-wrap: wrap;
                justify-content: center;
            }

            .personnel-card {
                background-color: #fff;
                border-radius: 8px;
                box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
                width: calc(50% - 20px); /* Two cards will share the same row */
                padding: 20px;
                text-align: left;
                transition: transform 0.3s ease, box-shadow 0.3s ease;
                margin-bottom: 20px; /* Ensure spacing between rows */
            }

            .personnel-card:nth-child(3) {
                width: 100%; /* Third card will take full width */
                max-width: 500px; /* Optional: Set a max width to prevent it from stretching too wide */
                margin-left: auto;
                margin-right: auto;
            }

            .personnel-card:hover {
                transform: translateY(-5px); /* Slight lift effect on hover */
                box-shadow: 0 8px 16px rgba(0, 0, 0, 0.2);
            }

            .personnel-card h4 {
                margin: 0 0 10px;
                font-size: 20px;
                color:  #1a7778;
            }

            .personnel-card h5 {
                margin: 0 0 15px;
                font-size: 16px;
                color: #666;
                font-weight: normal;
            }

            .personnel-card p {
                font-size: 15px;
                line-height: 1.6;
            }

            .personnel-card strong {
                color:  #1a7778;
            }

            #osp-services {
                margin: 40px 0;
            }

            .osp-services-container {
                display: flex;
                gap: 20px;
                justify-content: space-between;
                align-items: flex-start; /* Align items to the top */
            }

            .osp-text-container {
                flex: 1;
                max-width: 300px;
                background-color: #fff;
                padding: 20px;
                border-radius: 8px;
                box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            }

            .osp-image-container {
                display: grid;
                grid-template-columns: repeat(4, 1fr);
                gap: 10px 20px; /* Adjust first value for row gap, second value for column gap */
                flex: 2;
            }

            .osp-text-container ul {
                list-style: none;
                padding: 0;
                margin: 0;
            }

            .osp-text-container li {
                font-size: 16px;
                line-height: 1.6;
                color: #666;
                margin-bottom: 10px;
                display: flex;
                align-items: center;
            }

            .osp-text-container .tick {
                color: #2c6975;
                font-size: 20px;
                margin-right: 10px;
            }

            .osp-image-container img {
                width: 60%; /* Adjust the width percentage to control the size */
                height: 120px; /* Set a specific height for the images */
                border-radius: 10px;
                object-fit: cover;
                box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            }

            #bts-site {
                margin: 40px 0;
            }

            .bts-services-container {
                display: flex;
                gap: 20px;
                justify-content: space-between;
                align-items: flex-start; /* Align items to the top */
            }

            .bts-text-container {
                flex: 1;
                max-width: 300px;
                background-color: #fff;
                padding: 20px;
                border-radius: 8px;
                box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            }

            .bts-image-container {
                display: grid;
                grid-template-columns: repeat(4, 1fr);
                gap: 10px 20px; /* Adjust first value for row gap, second value for column gap */
                flex: 2;
            }

            .bts-text-container ul {
                list-style: none;
                padding: 0;
                margin: 0;
            }

            .bts-text-container li {
                font-size: 16px;
                line-height: 1.6;
                color: #666;
                margin-bottom: 10px;
                display: flex;
                align-items: center;
            }

            .bts-text-container .tick {
                color: #2c6975;
                font-size: 20px;
                margin-right: 10px;
            }

            .bts-image-container img {
                width: 60%; /* Adjust the width percentage to control the size */
                height: 120px; /* Set a specific height for the images */
                border-radius: 10px;
                object-fit: cover;
                box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            }







            /* Other existing CSS */

            .key-personnel {
                background-color: #fff;
                border-radius: 8px;
                box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
                padding: 20px;
                text-align: center;
                margin-bottom: 40px;
                transition: transform 0.3s ease, box-shadow 0.3s ease;
                width: 80%; /* Adjust the width as needed, e.g., 80% of the parent container */
                margin-left: auto; /* Center the element */
                margin-right: auto; /* Center the element */
            }

            .key-personnel h3 {
                margin-bottom: 10px;
                color: #1a7778;
                font-size: 24px;
            }

            .key-personnel p {
                font-size: 16px;
                color: #666;
                line-height: 1.6;
            }

            /* Add the hover effect */
            .key-personnel:hover {
                transform: translateY(-10px); /* Lift effect on hover */
                box-shadow: 0 12px 20px rgba(0, 0, 0, 0.2); /* Deeper shadow on hover */
            }

        </style>
    </head>
    <body>
        <header>
            <img src="<?php echo base_url('assets/images/logo.jpg'); ?>" alt="Company Logo" class="logo">
            <h1>CFI ALLIANCE SDN BHD</h1>
            <nav>
                <ul>

                    <li><a href="#about">About</a></li>
                    <li><a href="#services">Services</a></li>
                    <li><a href="#contact">Contact</a></li>

                </ul>
            </nav>
        </header>

        <main>
            <section id="about">
                <h2>About Us</h2>
                <p>CFI Alliance SDN BHD (1152213-T) was founded by a group of highly experienced Civil Infrastructure and M&E contractors in an effort to provide a total solution for infrastructure development in Tele-communication fields. Collectively we have over 10 years experiences in the Outside Plant (OSP), related fiber works for OSP, 24/7 Fiber Maintenance support in Klang Valley Region, construction of telecommunication cabins, M&E works for the telecommunication cabins, TI Installation, lightning protection works etc. Our successful delivery of completed works in Whole Malaysia for the major mobile telecommunication companies, have earned the company recognition as one which truly understand the needs of the mobile telecommunication companies.</p>
            </section>

            <section>
                <div class="card-container">
                    <div class="card">
                        <h3>Mission</h3>
                        <p>We are a telecommunication engineering contractor delivering expert manpower and innovative, timely projects to ensure customer satisfaction and community growth.</p>
                    </div>
                    <div class="card">
                        <h3>Vision</h3>
                        <p>A leading multinational Telco engineering services provider of choice.</p>
                    </div>
                    <div class="card">
                        <h3>Core Values</h3>
                        <p>Cohesiveness, Passion, Professionalism, Loyalty.</p>
                    </div>
                </div>
            </section>

            <section id="services">
                <h2>Our Services</h2>
                <div class="personnel-container">
                    <div class="personnel-card">
                        <h4>Fiber Optics</h4>
                        <h5>Installation and Maintenance</h5>
                        <p>CFI ALLIANCE SDN BHD has skilled manpower and the latest equipment for underground cabling, splicing, and maintenance to ensure high-speed and stable connections.</p>
                    </div>
                    <div class="personnel-card">
                        <h4>Telecommunication Infrastructure</h4>
                        <h5>Planning and Construction</h5>
                        <p>We provide comprehensive infrastructure planning and construction services, ensuring quality and compliance with industry standards.</p>
                    </div>
                    <div class="personnel-card">
                        <h4>TI Installation</h4>
                        <h5>Comprehensive Services</h5>
                        <p>We offer full turnkey solutions, from equipment installation to testing and commissioning, ensuring reliable telecommunication services.</p>
                    </div>
                </div>
                <section id="osp-services">
                    <h2>Osp Site Photo</h2>
                    <div class="osp-services-container">
                        <div class="osp-text-container">
                            <ul>
                                <li><span class="tick">&#10003;</span>Horizontal Directional Drilling</li>
                                <li><span class="tick">&#10003;</span>Manhole Installation</li>
                                <li><span class="tick">&#10003;</span>HDD Main Duct Installation</li>
                                <li><span class="tick">&#10003;</span>Micro Trenching on Carriage Way</li>
                                <li><span class="tick">&#10003;</span>Micro Trenching on Yello Line</li>
                                <li><span class="tick">&#10003;</span>Open Trenching on Grass Verge</li>
                                <li><span class="tick">&#10003;</span>Micro Duct Installation</li>
                                <li><span class="tick">&#10003;</span>Aerial Fiber Pole </li>
                                <li><span class="tick">&#10003;</span>Optical Fiber Cable </li>
                                <li><span class="tick">&#10003;</span>Optical Fiber Splicing in Closure</li>
                                <!-- Add more items similarly -->
                            </ul>
                        </div>
                        <div class="osp-image-container">
                            <img src="<?php echo base_url('assets/images/horizontaldirection.jpg'); ?>" alt="OSP Site Photo">
                            <img src="<?php echo base_url('assets/images/manholeinstallation.jpg'); ?>" alt="Drilling Manhole Installation">
                            <img src="<?php echo base_url('assets/images/hdd.jpg'); ?>" alt="HDD Main Duct Installation">
                            <img src="<?php echo base_url('assets/images/micro.jpg'); ?>" alt="Micro Trenching on Carriage Way">
                            <img src="<?php echo base_url('assets/images/microyellow.jpg'); ?>" alt="OSP Site Photo">
                            <img src="<?php echo base_url('assets/images/opentrenching.jpg'); ?>" alt="Drilling Manhole Installation">
                            <img src="<?php echo base_url('assets/images/microduct.jpg'); ?>" alt="HDD Main Duct Installation">
                            <img src="<?php echo base_url('assets/images/aerialfiber.jpg'); ?>" alt="Micro Trenching on Carriage Way">
                            <img src="<?php echo base_url('assets/images/opticalfiber.jpg'); ?>" alt="HDD Main Duct Installation">
                            <img src="<?php echo base_url('assets/images/opticalfibersplicing.jpg'); ?>" alt="Micro Trenching on Carriage Way">
                            <!-- Add more images similarly -->
                        </div>
                    </div>
                </section>

                <section id="bts-site">
                    <h2>BTS Site Photo</h2>
                    <div class="bts-services-container">
                        <div class="bts-text-container">
                            <ul>
                                <li><span class="tick">&#10003;</span>New Site - Roof Top</li>
                                <li><span class="tick">&#10003;</span>New Site - Vacant Land</li>
                                <li><span class="tick">&#10003;</span>Upgrading Site - Roof Top</li>
                                <li><span class="tick">&#10003;</span>Upgrading Site - Vacant Land</li>
                                <li><span class="tick">&#10003;</span>Tower Erection</li>
                                <li><span class="tick">&#10003;</span>Microwave Installation</li>
                                <li><span class="tick">&#10003;</span>Telecommunication Installation</li>

                                <!-- Add more items similarly -->
                            </ul>
                        </div>
                        <div class="bts-image-container">
                            <img src="<?php echo base_url('assets/images/newsite1.jpg'); ?>" alt="New Site - Roof Top1">
                            <img src="<?php echo base_url('assets/images/newsite2.jpg'); ?>" alt="New Site - Roof Top2">
                            <img src="<?php echo base_url('assets/images/vacantland1.jpg'); ?>" alt="New Site - Vacant Land1">
                            <img src="<?php echo base_url('assets/images/vacantland2.jpg'); ?>" alt="New Site - Vacant Land2">
                            <img src="<?php echo base_url('assets/images/upgradingsite-rooftop1.jpg'); ?>" alt="Upgrading Site - Roof Top1">
                            <img src="<?php echo base_url('assets/images/upgradingsite-rooftop2.jpg'); ?>" alt="Upgrading Site - Roof Top2">
                            <img src="<?php echo base_url('assets/images/upgradingsite-vacantland1.jpg'); ?>" alt="Upgrading Site - Vacant Land1">
                            <img src="<?php echo base_url('assets/images/upgradingsite-vacantland2.jpg'); ?>" alt="Upgrading Site - Vacant Land2">
                            <img src="<?php echo base_url('assets/images/towererection1.jpg'); ?>" alt="Tower Erection1">
                            <img src="<?php echo base_url('assets/images/towererection2.jpg'); ?>" alt="Tower Erection2">
                            <img src="<?php echo base_url('assets/images/microwaveinstallation1.jpg'); ?>" alt="Microwave Installation1">
                            <img src="<?php echo base_url('assets/images/microwaveinstallation2.jpg'); ?>" alt="Microwave Installation2">
                            <img src="<?php echo base_url('assets/images/telecommunicationinstallation1.jpg'); ?>" alt="Microwave Installation1">
                            <img src="<?php echo base_url('assets/images/telecommunicationinstallation2.jpg'); ?>" alt="Microwave Installation2">

                            <!-- Add more images similarly -->
                        </div>
                    </div>
                </section>



            </section>


            <section id="key-personnel">
                <h2>Key Personnel</h2>
                <div class="key-personnel">
                    <h3>Ong Chong Yong</h3>
                    <h4>Managing Director</h4>
                    <p>Mr. Ong holds a Diploma in Mechanical Engineering from Politeknik Shah Alam, Malaysia. With over 15 years of comprehensive experience in project management, he possesses specialized expertise in budgeting, bidding, procurement, and the full spectrum of project execution. 
                        His professional background is particularly distinguished in the telecommunications and construction sectors, where he has consistently overseen the successful delivery of major projects. Prior to his current position as Managing Director of CFI Alliance Sdn Bhd, 
                        Mr. Ong held key leadership roles at Naxus Communication Sdn Bhd and STK Engineering Sdn Bhd, among others.</p>
                </div>


            </section>

            <section id="contact">
                <h2>Contact Us</h2>
                <div class="contact-wrapper">
                    <div class="map">
                        <iframe 
                            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d15939.038078514292!2d101.6214419!3d3.0909299!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x31cc4afc89c926f1%3A0x7112d8c8171a6b44!2sTelekom%20Malaysia%20Training%20Centre!5e0!3m2!1sen!2smy!4v1643179222127!5m2!1sen!2smy"
                            width="100%" height="450" style="border:0;" allowfullscreen="" loading="lazy"></iframe>
                    </div>
                    <div class="contact-form">
                        <form>
                            <input type="text" placeholder="Name" required>
                            <input type="email" placeholder="Email" required>
                            <textarea placeholder="Your Message" rows="5" required></textarea>
                            <button type="submit">Send Message</button>
                        </form>
                    </div>
                </div>
            </section>
        </main>

        <footer>
            <p>CFI ALLIANCE SDN BHD © 2024. All Rights Reserved.</p>
        </footer>

        <script>
            document.querySelectorAll('a[href^="#"]').forEach(anchor => {
                anchor.addEventListener('click', function (e) {
                    e.preventDefault();

                    document.querySelector(this.getAttribute('href')).scrollIntoView({
                        behavior: 'smooth'
                    });
                });
            });
        </script>
    </body>
</html>
